<?php $__env->startSection('content'); ?>

<div class="row">

    <div class="col-md-12">
        <div class="block block-themed">
            <div class="block-header bg-light">
                <h3 class="block-title">
                    <a href="<?php echo e(route('web.home.index')); ?>">
                        <?php echo e(__('dcm.home')); ?>

                </a> » Submit a Report
                </h3>
            </div>


            <div class="block block-square ">
                <div class="block-header block-header-default">
                    <h3 class="block-title"> <i class="fa fa-fw fa-envelope-square mr-1"></i>Tell us your story.</h3>
                </div>
                <div class="block-content  px-3 py-3">

                    <form action="<?php echo e(route('web.home.reportcontent.post')); ?>" method="POST" enctype="multipart/form-data" >
                        <?php echo csrf_field(); ?>
                        <div class="row push">
                            <div class="col-lg-4">
                                <p class="text-muted">
                                    Report Abusive Content
                                </p>
                            </div>
                            <div class="col-lg-8">
                                <div class="form-group">
                                    <?php if($errors->any()): ?>
                                        <div class="alert alert-danger text-left m-t-10">
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                            </button>
                                            <h3 class="alert-heading font-size-h4 my-2">Error</h3>
                                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p class="mb-0"><?php echo e($error); ?></p>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>

                                    <?php endif; ?>
                                    <?php if(session('success')): ?>

                                        <div class="alert alert-success text-left m-t-10">
                                            <p><i class="fa fa-check"></i> <?php echo e(session('success')); ?></p>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <div class="form-group">
                                    <label for="url">URL of inappropriate content or apps <small class="text-danger">*</small></label>
                                    <input type="text" class="form-control" id="url" name="url" value="<?php echo e($report_url ?? ''); ?>" placeholder="URL of inappropriate content or apps">
                                </div>

                                <div class="form-group">
                                    <label for="name">Your name <small class="text-danger">*</small></label>
                                    <input type="text" class="form-control" id="name" name="name" placeholder="Your name">
                                </div>
                                <div class="form-group">
                                    <label for="email">Email <small class="text-danger">*</small></label>
                                    <input type="email" class="form-control" id="email" name="email" placeholder="Your email">
                                </div>

                                <div class="form-group">
                                    <label for="subject">Subject</label>
                                    <input type="text" class="form-control" id="subject" name="subject" placeholder="Your subject">
                                </div>

                                <div class="form-group">
                                    <label for="reason">Reason for reporting: </label>
                                    <div class="radio">

                                        <?php if(isset($reason_items)): ?>

                                        <?php $__currentLoopData = $reason_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="field">
                                                <div><input type="radio" name="reason" value="<?php echo e($item['identifier']); ?>" <?php echo e(($item['selected'] === true) ? 'checked' : ''); ?>> <?php echo e($item['label']); ?></div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="message">Any other things you wanna tell us? <small class="text-danger">*</small></label>
                                    <textarea class="form-control" id="message" name="message" rows="10" placeholder="Your question or comments..."></textarea>
                                </div>

                                <?php if( dcmConfig('is_recaptcha') == 'yes' && dcmConfig('recaptcha_on_report_content') == 'yes' && dcmConfig('recaptcha_site_key')): ?>
                                    <div class="form-group ">
                                        <div class="g-recaptcha" data-sitekey="<?php echo e(dcmConfig('recaptcha_site_key')); ?>"></div>
                                    </div>
                                <?php endif; ?>

                                <div class="form-group">
                                    <button type="submit" class="btn btn-block btn-hero-primary">
                                        <i class="fa fa-fw fa-envelope mr-1"></i> Send
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

        </div>

    </div>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('javascript'); ?>
    <?php if( dcmConfig('is_recaptcha') == 'yes' && dcmConfig('recaptcha_on_report_content') == 'yes' && dcmConfig('recaptcha_site_key')): ?>
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>
<?php echo $__env->make( "layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>